--- #18675 Standard Datenimport  /  -Update

--- Create Import-Schemna
CREATE SCHEMA "x_950_import";
---

CREATE OR REPLACE FUNCTION x_950_import.CSV_rows(
      IN _tabname      varchar,              --- PRODAT Tablename
      IN _c_list_v     varchar   = null      --- Feldnamen-Liste
  ) RETURNS SETOF varchar AS $$
  DECLARE
          rec                record;
          _line_cn           varchar := '';           --- information_schema.columns.column_name
          _line_dt           varchar := '';           --- information_schema.columns.data_type
          _line_isn          varchar := '';           --- information_schema.columns.is_nullable
          _line_def          varchar := '';           --- information_schema.columns.column_default
          _line_fa           varchar := '';           --- Feldaiase
          _c_list            varchar[];
          _sql               varchar;                 --- SQL-Script. Tabelle für Delphi 'Moving Data'
          _metadaten         boolean := false;         --- Metadaten-Anzeige: true - vollständig, false - nur Spaltennamen
  BEGIN

    SELECT string_to_array( _c_list_v, ';' ) INTO _c_list;

    FOR rec IN SELECT
                 column_name::varchar,
                 GetFieldAlias( column_name::varchar ) AS feldalias,
                 CASE
          WHEN data_type = 'character varying' THEN
              'varchar(' || character_maximum_length || ')'
          WHEN data_type = 'numeric' THEN
              'numeric(' || numeric_precision || ', ' || numeric_scale || ')'
          ELSE
              data_type
     END AS data_type,
     is_nullable::varchar,
     column_default::varchar
         FROM information_schema.columns
         WHERE
                 CASE WHEN array_length( _c_list, 1 ) > 0 THEN
                          table_name = _tabname
                          AND table_schema = 'public'
              AND column_name NOT IN ( 'dbrid', 'insert_date', 'insert_by', 'modified_by', 'modified_date' )
              AND coalesce( column_default::varchar, '' ) NOT iLIKE 'nextval(%'
              AND coalesce( array_position( _c_list, column_name::varchar ), 0 ) > 0
                      ELSE
                          table_name = _tabname
                          AND table_schema = 'public'
              AND column_name NOT IN ( 'dbrid', 'insert_date', 'insert_by', 'modified_by', 'modified_date' )
              AND coalesce( column_default::varchar, '' ) NOT iLIKE 'nextval(%'
                 END
    LOOP

        _line_cn  := _line_cn  || coalesce( rec.column_name   , '' ) || ';';
        _line_fa  := _line_fa  || coalesce( rec.feldalias     , '' ) || ';';
        _line_dt  := _line_dt  || coalesce( rec.data_type     , '' ) || ';';
        _line_isn := _line_isn || coalesce( rec.is_nullable   , '' ) || ';';
        _line_def := _line_def || coalesce( rec.column_default, '' ) || ';';

    END LOOP;

    ---
    IF _metadaten THEN
        RETURN NEXT _line_cn;
        RETURN NEXT _line_cn;
        RETURN NEXT _line_fa;
        RETURN NEXT _line_dt;
        RETURN NEXT _line_isn;
        RETURN NEXT _line_def;
    ELSE
        RETURN NEXT _line_cn;
    END IF;

    --- Tabellen , und importmove erstellen
    PERFORM  x_950_import.create__table__import_xxx( _tabname, _c_list_v );

    RETURN;
  END $$ LANGUAGE plpgsql;
---

CREATE OR REPLACE FUNCTION x_950_import.x_950_import__table__create(
      IN _tabname                    varchar,   --- PRODAT Tablename
      IN _c_list_v                   varchar = null,
      IN _generate_missing_fields    boolean default true,    --- mit oder ohne Felder dbrid, insert_by, ....
      IN _not_nextval                boolean default true     --- mit oder ohne primary key
  ) RETURNS void AS $$
  DECLARE
          rec                record;
          _c_list            varchar[];
          _create_table      varchar := '';
          _sql               varchar := '';
          _in_select         varchar := '';
  BEGIN

    _c_list_v     := lower( _c_list_v );

    _create_table :=                  'DROP TABLE IF EXISTS x_950_import.' || _tabname || ' CASCADE;' || chr( 10 );
    _create_table := _create_table || 'CREATE TABLE x_950_import.' || _tabname || ' (' || chr( 10 );

    SELECT string_to_array( _c_list_v, ';' ) INTO _c_list;

    IF _c_list_v IS null AND char_length( trim( _c_list_v ) ) = 0 THEN
        _in_select := 'SELECT column_name::varchar'                      || chr(10)
                   || 'FROM information_schema.columns'                  || chr(10)
                   || 'WHERE table_name = ' || quote_literal( _tabname ) || chr(10)
                   || '  AND table_schema = ''public'''                  || chr(10)
                   || '  AND column_name NOT IN ( ''dbrid'', ''insert_date'', ''insert_by'', ''modified_by'', ''modified_date'' )' || chr(10);

        IF array_length( _c_list, 1 ) > 0 THEN
            _in_select := _in_select || '  AND coalesce( array_position( ' || quote_literal( _c_list ) || ', column_name::varchar ), 0 ) > 0' || chr(10);
        END IF;
    ELSE

        --- Variante direkt von Spaltenliste
        _in_select := 'SELECT * FROM unnest( array[''' || replace( _c_list_v, ';', ''',''' ) || '''] )  as column_name';

    END IF;

    IF _not_nextval THEN
        _in_select := _in_select || '  AND coalesce( column_default::varchar, '''' ) NOT iLIKE ''nextval(%'' ' || chr(10);
    END IF;

    --- raise notice '_in_select = %', _in_select;

    FOR rec IN execute( _in_select )
      LOOP
        --- Table-Script
        _create_table := _create_table || '  ' || rec.column_name || repeat(' ', 40 - char_length( rec.column_name ) ) || 'varchar,' || chr( 10 );

        --- raise notice 'rec.column_name = %', rec.column_name;

    END LOOP;

    _create_table := substring( _create_table from 1 for char_length( _create_table ) - 2 ); -- || chr( 10 );

    IF _generate_missing_fields THEN
        _create_table := _create_table || ',' || chr(10)
                                       || '  dbrid'         || repeat(' ', 40 - char_length( 'dbrid' ) )         || 'varchar(32) NOT NULL DEFAULT nextval(''db_id_seq''),' || chr(10)
                                       || '  insert_date'   || repeat(' ', 40 - char_length( 'insert_date' ) )   || 'date,'        || chr(10)
                                       || '  insert_by'     || repeat(' ', 40 - char_length( 'insert_by' ) )     || 'varchar(32),' || chr(10)
                                       || '  modified_by'   || repeat(' ', 40 - char_length( 'modified_by' ) )   || 'varchar(32),' || chr(10)
                                       || '  modified_date' || repeat(' ', 40 - char_length( 'modified_date' ) ) || 'timestamp(0)';
    END IF;

    _create_table := _create_table || chr(10) || ' );';

    EXECUTE _create_table;                                                    --- Tabelle x_950_import.XXX

    _sql := 'SELECT x_950_import.record__validate__create__' || _tabname || '()';
    EXECUTE _sql;

    RETURN;
  END $$ LANGUAGE plpgsql;
---

--- #18787  importierte Daten validieren

--- adk-Datensatz validieren
CREATE OR REPLACE FUNCTION x_950_import.record__validate__create__adk() RETURNS void
  AS $f$
  BEGIN

  EXECUTE $func$

    CREATE OR REPLACE FUNCTION x_950_import.record__validate(
      IN _record                      x_950_import.adk,
      IN _generate__defaults_values   boolean = false,

      OUT valid        boolean,
      OUT message      varchar,
      OUT update       boolean
      ) RETURNS RECORD AS $$

      DECLARE    _sql     varchar := '';
      BEGIN
          valid  := true;
          update := false;
          message := '';

          -- Typcast ob die Daten in typ konvertierbar sind (zB ungültige Datum, Buchstaben in Zahlenfeldern usw)
          BEGIN
              IF EXISTS (SELECT true FROM adk WHERE ad_krz = upper( row_to_json( _record ) ->> 'ad_krz') ) THEN
            update := true;
              END IF;

              IF _generate__defaults_values THEN
            -- TODO erkennt nur Typfehler. bei Insert müßte entweder hier DEFAULT geholt werden oder ohne die Spalten
                  PERFORM ( jsonb_populate_record( null::adk, TSystem.tables__fields__generate__defaults_values( 'adk', row_to_json( _record )::jsonb ) )::adk ).*;
              ELSE
                  PERFORM ( jsonb_populate_record( null::adk, row_to_json( _record )::jsonb /*)*/ )::adk ).*;
              END IF;

          EXCEPTION WHEN OTHERS THEN
              valid := false;
              message := sqlErrm;
          END;

          RETURN;
     END $$ LANGUAGE plpgsql STABLE;

  $func$ -- EXECUTE end
  RETURN;
END $f$ LANGUAGE plpgsql;

CREATE TABLE x_950_import.adk AS TABLE adk;
SELECT x_950_import.record__validate__create__adk();
 ---

CREATE OR REPLACE FUNCTION x_950_import.record__validate__create__art() RETURNS void
  AS $f$
  BEGIN

  EXECUTE $func$

    CREATE OR REPLACE FUNCTION x_950_import.record__validate(
      IN _record                      x_950_import.art,
      IN _generate__defaults_values   boolean = false,

      OUT valid        boolean,
      OUT update       boolean,
      OUT message      varchar
      ) RETURNS RECORD AS $$

      DECLARE    _sql     varchar := '';
        EXCEPTION_TEXT    VARCHAR;
        EXCEPTION_DETAIL  VARCHAR;
        EXCEPTION_HINT    VARCHAR;
      BEGIN
          valid  := true;
          update := false;
          -- Typcast ob die Daten in typ konvertierbar sind (zB ungültige Datum, Buchstaben in Zahlenfeldern usw)
          BEGIN
              IF EXISTS (SELECT true FROM art WHERE ak_nr = upper( row_to_json( _record ) ->> 'ak_nr') ) THEN
            update := true;
              ELSE
                  IF _generate__defaults_values THEN
                      PERFORM ( jsonb_populate_record( null::art, TSystem.tables__fields__generate__defaults_values( 'art1', row_to_json( _record )::jsonb ) )::art ).*;
                  ELSE
                      PERFORM ( jsonb_populate_record( null::art, row_to_json( _record )::jsonb )::art ).*;
                  END IF;
              END IF;


          EXCEPTION WHEN OTHERS THEN
              BEGIN
                  GET STACKED DIAGNOSTICS EXCEPTION_TEXT = MESSAGE_TEXT
                                         ,EXCEPTION_DETAIL =    PG_EXCEPTION_DETAIL
                                         ,EXCEPTION_HINT = PG_EXCEPTION_HINT
                 ;
                 valid := false;
                 update := false;
                 message := EXCEPTION_DETAIL;
             END;
        END;

          RETURN;
     END $$ LANGUAGE plpgsql STABLE;

  $func$ -- EXECUTE end
  RETURN;
END $f$ LANGUAGE plpgsql;

CREATE TABLE x_950_import.art AS TABLE art;
SELECT x_950_import.record__validate__create__art();
---

CREATE OR REPLACE FUNCTION x_950_import.TableStruktur__Get( IN _tabname varchar )
  RETURNS varchar AS $$
  DECLARE   _result    varchar := '';
            rec        record;
  BEGIN

    FOR rec IN SELECT
                 column_name::varchar
         FROM information_schema.columns
         WHERE table_name = _tabname
                 AND table_schema = 'x_950_import'
     AND column_name NOT IN ( 'dbrid', 'insert_date', 'insert_by', 'modified_by', 'modified_date', 'error_message' )
    LOOP
      _result := _result || rec.column_name || ';';
    END LOOP;

    IF char_length( trim( _result ) ) > 1 THEN
        _result := substring( _result, 1, char_length( _result ) - 1 );
    END IF;
    RETURN _result;

  END $$ LANGUAGE plpgsql VOLATILE;
--
CREATE OR REPLACE FUNCTION x_950_import.adk__from__x_950_import__insert_into()
  RETURNS text AS $$
  DECLARE
        rec          record;
        _fehler      text    := '';
        _sql         varchar := '';
        EXCEPTION_TEXT    VARCHAR;
        EXCEPTION_DETAIL  VARCHAR;
        EXCEPTION_HINT    VARCHAR;
        ---
        _c_list            varchar[];
        _c_list_v          varchar;
        _value             varchar;
  BEGIN

    SELECT x_950_import.TableStruktur__Get('adk') INTO _c_list_v;
    SELECT string_to_array( _c_list_v, ';' ) INTO _c_list;

    ALTER TABLE x_950_import.adk ADD COLUMN IF NOT EXISTS error_message VARCHAR(150);
    UPDATE x_950_import.adk SET error_message = null;

    FOR rec IN SELECT *                                          --- ad_krz, dbrid, error_message
               FROM x_950_import.adk AS i_adk
               --WHERE  ad_krz = 'AGIEC-SCH' -- NOT exists( SELECT true FROM adk WHERE adk.ad_krz = i_adk.ad_krz )
    LOOP
        BEGIN
            IF NOT exists( SELECT true FROM adk WHERE ad_krz = rec.ad_krz ) THEN

                INSERT INTO adk
                  SELECT (jsonb_populate_record( null::adk, TSystem.tables__fields__generate__defaults_values( 'adk', row_to_json( i_adk )::jsonb ) )::adk ).*
                  FROM x_950_import.adk AS i_adk
                  WHERE ad_krz = rec.ad_krz
                  ORDER BY 1
                  LIMIT 1;                        --- 1. Adresse anlegen. Beim Doppelte Adresse: weitere werden updaten
            ELSE
                _sql := '';
                FOR i in array_lower( _c_list, 1 ) ..array_upper( _c_list, 1 ) LOOP
                    IF _c_list[i] <> 'ad_krz' THEN
                        EXECUTE 'SELECT ' || _c_list[i] || ' FROM x_950_import.adk WHERE ad_krz = ' || quote_literal( rec.ad_krz ) INTO _value;   --- Feldvalue
                        _sql := _sql || _c_list[i] || ' = ' || quote_literal( coalesce( _value, '' ) ) || ', ';
                    END IF;
                END LOOP;
                _sql := 'UPDATE adk SET ' || substr( _sql, 1, length( trim( _sql ) ) - 1) || ' WHERE ad_krz = ' || quote_literal( rec.ad_krz );

                PERFORM TSystem.trigger__disable('adk', 'adk__b_iu_adresschange' );
                EXECUTE _sql;
                PERFORM TSystem.trigger__enable( 'adk', 'adk__b_iu_adresschange' );

                raise notice '%', _sql;

            END IF;

            --- importierte Datensätze löschen
            DELETE FROM x_950_import.adk WHERE dbrid IN ( rec.dbrid );

        EXCEPTION WHEN others THEN
          BEGIN
            GET STACKED DIAGNOSTICS EXCEPTION_TEXT = MESSAGE_TEXT
                                   ,EXCEPTION_DETAIL = PG_EXCEPTION_DETAIL
                                   ,EXCEPTION_HINT = PG_EXCEPTION_HINT
            ;
            UPDATE x_950_import.adk SET error_message = substr( coalesce( EXCEPTION_TEXT, EXCEPTION_DETAIL, EXCEPTION_HINT ), 1, 150 ) WHERE dbrid IN ( rec.dbrid );
            _fehler := _fehler || chr(10) || EXCEPTION_TEXT;
            raise notice 'EXCEPTION: %, dbrid = %', concat_ws( ', ', '1. ' || EXCEPTION_TEXT, '2. ' || EXCEPTION_DETAIL, '3. ' || EXCEPTION_HINT ), rec.dbrid;
          END;
        END;

    END LOOP;

    --- Suche für angelegte Adressen aktivieren
    PERFORM count(1) FROM (SELECT TSystem.kws_create_keywords(adk) FROM adk) AS a;

    RETURN _fehler;
 END $$ LANGUAGE plpgsql VOLATILE;
---

CREATE OR REPLACE FUNCTION x_950_import.art__from__x_950_import__insert_into()
  RETURNS text AS $$
  DECLARE
        rec          record;
        _fehler      text    := '';
        _sql         varchar := '';
        EXCEPTION_TEXT    VARCHAR;
        EXCEPTION_DETAIL  VARCHAR;
        EXCEPTION_HINT    VARCHAR;
        ---
        _c_list            varchar[];
        _c_list_v          varchar;
        _value             varchar;
  BEGIN

    SELECT x_950_import.TableStruktur__Get('art') INTO _c_list_v;
    SELECT string_to_array( _c_list_v, ';' ) INTO _c_list;

  ALTER TABLE x_950_import.art ADD COLUMN IF NOT EXISTS dbrid VARCHAR(32) NOT NULL DEFAULT nextval('db_id_seq');

    ALTER TABLE x_950_import.art ADD COLUMN IF NOT EXISTS error_message VARCHAR(150);
    UPDATE x_950_import.art SET error_message = null;
    ---

    ALTER TABLE x_950_import.art ADD COLUMN IF NOT EXISTS ak_standard_mgc SMALLINT;
    UPDATE x_950_import.art SET ak_standard_mgc = 1 WHERE ak_standard_mgc IS null OR upper( ak_standard_mgc ) in( 'STÜCK', 'STK.', 'STK' );

    ---
    --- AC 'IMPORT' beim Bedarf anlegen
    INSERT INTO artcod (ac_n    , ac_i, ac_b       )
    SELECT              'IMPORT', 999   , 'Import'
    WHERE NOT EXISTS(SELECT TRUE FROM artcod WHERE ac_n = 'IMPORT');
    ---

    --- Spalte 'ak_ac' beim Bedarf anlegen und ausfühlen
    ALTER TABLE x_950_import.art ADD COLUMN IF NOT EXISTS ak_ac VARCHAR(9);
    UPDATE x_950_import.art SET ak_ac = 'IMPORT' WHERE ak_ac IS null;
  ---
  UPDATE x_950_import.art SET ak_standard_mgc = tartikel.me_code__from__me_iso(ak_standard_mgc);

    ---
    raise notice '------------------------------------------------------------------------------------------------------------';
    FOR rec IN SELECT *                                          --- ak_ac, ak_nr, dbrid
               FROM x_950_import.art AS i_art
             --  WHERE ak_nr = 'TEST-111'   --NOT exists( SELECT true FROM art WHERE art.ak_nr = i_adk.ak_nr )
    LOOP
        BEGIN
            IF NOT exists( SELECT true FROM art WHERE art.ak_nr = rec.ak_nr ) THEN
                INSERT INTO art
                  SELECT (jsonb_populate_record( null::art, TSystem.tables__fields__generate__defaults_values( 'art', row_to_json( i_art )::jsonb ) )::art ).*
                  FROM x_950_import.art AS i_art
                  WHERE ak_nr = rec.ak_nr
                  ORDER BY 1
                  LIMIT 1;                        --- 1. Artikel anlegen. Beim Doppelte Artikel: weitere werden updaten

                --- importierte Datensätze löschen
                --- DELETE FROM x_950_import.art WHERE dbrid IN ( rec.dbrid );
            ELSE
                _sql := '';
                FOR i in array_lower( _c_list, 1 ) ..array_upper( _c_list, 1 ) LOOP
                    IF _c_list[i] <> 'ak_nr' THEN
                        EXECUTE 'SELECT ' || _c_list[i] || ' FROM x_950_import.art WHERE ak_nr = ' || quote_literal( rec.ak_nr ) INTO _value;   --- Feldvalue
                        _sql := _sql || _c_list[i] || ' = ' || quote_literal( coalesce( _value, '' ) ) || ', ';
                    END IF;
                END LOOP;
                _sql := 'UPDATE art SET ' || substr( _sql, 1, length( trim( _sql ) ) - 1) || ' WHERE ak_nr = ' || quote_literal( rec.ak_nr );
                EXECUTE _sql;
                raise notice '%', _sql;
            END IF;
            --- importierte Datensätze löschen
            DELETE FROM x_950_import.art WHERE dbrid IN ( rec.dbrid );

        EXCEPTION WHEN others THEN
          BEGIN
            GET STACKED DIAGNOSTICS EXCEPTION_TEXT = MESSAGE_TEXT
                                   ,EXCEPTION_DETAIL = PG_EXCEPTION_DETAIL
                                   ,EXCEPTION_HINT = PG_EXCEPTION_HINT
            ;
            _fehler := concat_ws( ' ', _fehler, 'Fehler: ', /*EXCEPTION_TEXT, '-',*/ EXCEPTION_DETAIL, /*'-', EXCEPTION_HINT,*/ chr(10) );
            UPDATE x_950_import.art SET error_message = substr( coalesce( EXCEPTION_DETAIL, EXCEPTION_TEXT, EXCEPTION_HINT ), 1, 150 ) WHERE dbrid IN ( rec.dbrid );
          END;
        END;

    END LOOP;

    --- Suche für angelegte Atrikel aktivieren
    PERFORM count(1) FROM (SELECT TSystem.kws_create_keywords(art) FROM art) AS a;

    RETURN _fehler;
 END $$ LANGUAGE plpgsql VOLATILE;
---

CREATE OR REPLACE FUNCTION x_950_import.Metadaten_Fields__Get(
      IN _tabname      varchar,              --- PRODAT Tablename
      IN _c_list_v     varchar   = null      --- Feldnamen-Liste
  ) RETURNS TABLE (
                    cn         varchar,   --- column_name
                    fa         varchar,   --- feldalias
                    dt         varchar,   --- data_type
                    is_null    varchar,   --- is_nullable
                    def        varchar    --- column_default
                  ) AS $$
  DECLARE
          rec                record;
          _c_list            varchar[];
       --   _sql               varchar;                 --- SQL-Script. Tabelle für Delphi 'Moving Data'
  BEGIN

    SELECT string_to_array( _c_list_v, ';' ) INTO _c_list;

    FOR rec IN SELECT
                 column_name::varchar,
                 GetFieldAlias( column_name::varchar ) AS feldalias,
                 CASE
                      WHEN data_type = 'character varying' THEN
                          'varchar(' || character_maximum_length || ')'
                      WHEN data_type = 'numeric' THEN
                          'numeric(' || numeric_precision || ', ' || numeric_scale || ')'
                      ELSE
                          data_type
                 END AS data_type,
                 is_nullable::varchar,
                 column_default::varchar
               FROM information_schema.columns
               WHERE
                 table_name = _tabname
                 AND table_schema = 'public'
                 AND column_name NOT IN ( 'dbrid', 'insert_date', 'insert_by', 'modified_by', 'modified_date' )
                 AND coalesce( column_default::varchar, '' ) NOT iLIKE 'nextval(%'
                 AND coalesce( array_position( _c_list, column_name::varchar ), 0 ) > 0
    LOOP

        cn      := coalesce( rec.column_name   , '' );
        fa      := coalesce( rec.feldalias     , '' );
        dt      := coalesce( rec.data_type     , '' );
        is_null := coalesce( rec.is_nullable   , '' );
        def     := coalesce( rec.column_default, '' );

        RETURN NEXT;

    END LOOP;
  END $$ LANGUAGE plpgsql;
---

--- #19532 [PAL Demonstration] Import

--- Create Import-Schemna
CREATE SCHEMA IF NOT EXISTS "x_950_import";
---
CREATE TABLE x_950_import.projekt (
  pr_id                                   SERIAL PRIMARY KEY,
  pr_import_time                          timestamp(0),
  pr_error                                varchar,
  pr_parent_ab_ap_nr                      varchar,
  pr_an_nr                                varchar,
  pr_an_bez                               varchar,
  pr_ab_ap_nr                             varchar,
  pr_ab_ap_bem                            varchar,
  pr_ab_st_uf1                            numeric,
  pr_a2_n                                 integer,
  pr_a2_ks                                varchar,
  pr_a2_subject                           varchar
    );

CREATE OR REPLACE FUNCTION x_950_import__projekt__a_i() RETURNS TRIGGER AS $$
  DECLARE   _ab_ix              integer;
            _ab_dbrid           varchar;
            _ab_parentabk       integer;
            EXCEPTION_TEXT      VARCHAR;
            EXCEPTION_DETAIL    VARCHAR;
            EXCEPTION_HINT      VARCHAR;
            err_context         varchar;
            _a2_n               integer;
  BEGIN
    ---  ANL
    INSERT INTO anl ( an_nr, an_bez )
    SELECT new.pr_an_nr, new.pr_an_bez
    WHERE NOT EXISTS(SELECT TRUE FROM anl WHERE an_nr = new.pr_an_nr LIMIT 1);

    IF ( coalesce( char_length( new.pr_ab_ap_nr ), 0 ) = 0 ) AND ( coalesce( char_length( new.pr_ab_ap_bem ), 0 ) = 0 ) THEN
         RETURN new;
    END IF;

    SELECT dbrid INTO _ab_dbrid     FROM anl WHERE an_nr    = new.pr_an_nr;                           --- Haupt ABK (mit Projektnummer) merken

    SELECT ab_ix INTO _ab_parentabk FROM abk WHERE ab_ap_nr = new.pr_an_nr ORDER BY ab_ix LIMIT 1;    --- ABK-Index, dbrid von Artikel/Arbeitspaket merken

    IF ( coalesce( char_length( new.pr_ab_ap_nr ), 0 ) = 0 ) THEN
        new.pr_ab_ap_nr := new.pr_an_nr;
    END IF;

    new.pr_ab_ap_nr := upper( new.pr_ab_ap_nr );

    IF NOT EXISTS( SELECT TRUE FROM abk JOIN ab2 ON ab_ix = a2_ab_ix WHERE abk.ab_ap_nr = new.pr_ab_ap_nr AND ab_dbrid = _ab_dbrid AND ab_parentabk = _ab_parentabk LIMIT 1 ) THEN

        INSERT INTO abk ( ab_tablename, ab_parentabk , ab_ap_nr                , ab_ap_bem       , ab_st_uf1, ab_dbrid , ab_doeinkauf, ab_dolager )
        SELECT            'anl'       , _ab_parentabk, upper( new.pr_ab_ap_nr ), new.pr_ab_ap_bem, 1        , _ab_dbrid, false       , false
        WHERE new.pr_ab_ap_nr IS NOT null
        RETURNING ab_ix INTO _ab_ix;

    ELSE
        SELECT ab_ix INTO _ab_ix FROM abk WHERE ab_ap_nr = new.pr_ab_ap_nr AND ab_dbrid = _ab_dbrid AND ab_parentabk = _ab_parentabk LIMIT 1;
    END IF;

    IF ( coalesce( char_length( new.pr_a2_ks ), 0 ) > 0 ) THEN
        INSERT INTO ab2 ( a2_ab_ix, a2_ks, a2_subject )
        SELECT _ab_ix, new.pr_a2_ks, new.pr_a2_subject
        WHERE new.pr_a2_ks IS NOT null;
    END IF;

    DELETE FROM x_950_import.projekt WHERE pr_id = new.pr_id;
    ---
    RETURN new;
 END $$ LANGUAGE plpgsql;

CREATE TRIGGER x_950_import__projekt__a_i
 AFTER INSERT
 ON x_950_import.projekt
 FOR EACH ROW
 EXECUTE PROCEDURE x_950_import__projekt__a_i();
---  #19532  END

--- #21528
CREATE OR REPLACE FUNCTION x_950_import.opl__from__x_950_import__insert_into()
  RETURNS text AS $$
  DECLARE
        rec               record;
        _fehler           text := '';
        _sql              varchar := '';
        EXCEPTION_TEXT    varchar;
        EXCEPTION_DETAIL  varchar;
        EXCEPTION_HINT    varchar;
        ---
        _c_list           varchar[];
        _c_list_v         varchar;
        _value            varchar;
  BEGIN

    SELECT x_950_import.TableStruktur__Get('opl') INTO _c_list_v;
    SELECT string_to_array( _c_list_v, ';' ) INTO _c_list;

    ALTER TABLE x_950_import.opl ADD COLUMN IF NOT EXISTS dbrid VARCHAR(32) NOT NULL DEFAULT nextval('db_id_seq');

    ALTER TABLE x_950_import.opl ADD COLUMN IF NOT EXISTS error_message VARCHAR(150);
    UPDATE x_950_import.opl SET error_message = null;
    ---

    raise notice '------------------------------------------------------------------------------------------------------------';

    FOR rec IN SELECT *                                          --- ak_ac, ak_nr, dbrid
               FROM x_950_import.opl AS i_opl
    LOOP
        BEGIN
            IF NOT exists( SELECT true FROM opl WHERE opl.i_op_ix = rec.i_op_ix ) THEN
                INSERT INTO opl
                  SELECT (jsonb_populate_record( null::opl, TSystem.tables__fields__generate__defaults_values( 'opl', row_to_json( i_opl )::jsonb ) )::opl ).*
                  FROM x_950_import.opl AS i_opl
                  WHERE i_op_ix = rec.i_op_ix
                  --ORDER BY 1
                  LIMIT 1;
            ELSE
                _sql := '';
                FOR i in array_lower( _c_list, 1 ) ..array_upper( _c_list, 1 ) LOOP
                    IF _c_list[i] <> 'ak_nr' THEN
                        EXECUTE 'SELECT ' || _c_list[i] || ' FROM x_950_import.opl WHERE i_op_ix = ' || rec.i_op_ix INTO _value;   --- Feldvalue
                        _sql := _sql || _c_list[i] || ' = ' || quote_literal( coalesce( _value, '' ) ) || ', ';
                    END IF;
                END LOOP;
                _sql := 'UPDATE opl SET ' || substr( _sql, 1, length( trim( _sql ) ) - 1) || ' WHERE i_op_ix = ' || rec.i_op_ix;
                EXECUTE _sql;
                raise notice '%', _sql;
            END IF;
            --- importierte Datensätze löschen
            DELETE FROM x_950_import.opl WHERE dbrid IN ( rec.dbrid );

        EXCEPTION WHEN others THEN
          BEGIN
            GET STACKED DIAGNOSTICS EXCEPTION_TEXT = MESSAGE_TEXT
                                   ,EXCEPTION_DETAIL = PG_EXCEPTION_DETAIL
                                   ,EXCEPTION_HINT = PG_EXCEPTION_HINT
            ;
            _fehler := concat_ws( ' ', _fehler, 'Fehler: ', EXCEPTION_TEXT, '-', EXCEPTION_DETAIL, /*'-', EXCEPTION_HINT,*/ chr(10) );
            UPDATE x_950_import.opl SET error_message = substr( coalesce( EXCEPTION_DETAIL, EXCEPTION_TEXT, EXCEPTION_HINT ), 1, 150 ) WHERE dbrid IN ( rec.dbrid );
          END;
        END;

    END LOOP;

    RETURN _fehler;
 END $$ LANGUAGE plpgsql VOLATILE;
---
CREATE OR REPLACE FUNCTION x_950_import.op2__from__x_950_import__insert_into()
  RETURNS text AS $$
  DECLARE
        rec               record;
        _fehler           text    := '';
        _sql              varchar := '';
        EXCEPTION_TEXT    varchar;
        EXCEPTION_DETAIL  varchar;
        EXCEPTION_HINT    varchar;
        ---
        _c_list           varchar[];
        _c_list_v         varchar;
        _value            varchar;
  BEGIN

    SELECT x_950_import.TableStruktur__Get('op2') INTO _c_list_v;
    SELECT string_to_array( _c_list_v, ';' ) INTO _c_list;

    ALTER TABLE x_950_import.op2 ADD COLUMN IF NOT EXISTS dbrid VARCHAR(32) NOT NULL DEFAULT nextval('db_id_seq');

    ALTER TABLE x_950_import.op2 ADD COLUMN IF NOT EXISTS error_message VARCHAR(150);
    UPDATE x_950_import.op2 SET error_message = null;
    ---

    raise notice '------------------------------------------------------------------------------------------------------------';
    FOR rec IN SELECT *                                          --- ak_ac, ak_nr, dbrid
               FROM x_950_import.op2
               ORDER BY o2_ix, o2_n
    LOOP
        BEGIN

            IF NOT exists( SELECT true FROM op2 WHERE o2_ix = rec.o2_ix AND o2_n = rec.o2_n ) THEN
                INSERT INTO op2
                  SELECT (jsonb_populate_record( null::op2, TSystem.tables__fields__generate__defaults_values( 'op2', row_to_json( i_op2 )::jsonb ) )::op2 ).*
                  FROM x_950_import.op2 AS i_op2
                  ;
            ELSE
                _sql := '';
                FOR i in array_lower( _c_list, 1 ) ..array_upper( _c_list, 1 ) LOOP
                    EXECUTE 'SELECT ' || _c_list[i] || ' FROM x_950_import.op2 WHERE o2_ix = ' || rec.o2_ix
                         || ' AND o2_n = ' || rec.o2_n INTO _value;   --- Feldvalue
                    _sql := _sql || _c_list[i] || ' = '
                                 || quote_literal( coalesce( _value, '' ) )
                                 || ', ';
                END LOOP;

                _sql := 'UPDATE op2 SET ' || substr( _sql, 1, length( trim( _sql ) ) - 1)
                     || ' WHERE o2_ix = ' || rec.o2_ix || ' AND o2_n = ' || rec.o2_n;

                _sql := replace( _sql, '''''', 'null');
                _sql := replace( _sql, '''f''', 'false' );
                _sql := replace( _sql, '''t''', 'true' );
                _sql := replace( _sql, '->', '-' );

                EXECUTE _sql;
                raise notice '%', _sql;
            END IF;
            --- importierte Datensätze löschen
            DELETE FROM x_950_import.op2 WHERE dbrid IN ( rec.dbrid );

        EXCEPTION WHEN others THEN
          BEGIN
            GET STACKED DIAGNOSTICS EXCEPTION_TEXT   = MESSAGE_TEXT
                                   ,EXCEPTION_DETAIL = PG_EXCEPTION_DETAIL
                                   ,EXCEPTION_HINT   = PG_EXCEPTION_HINT
            ;
            _fehler := concat_ws( ' ', _fehler, 'Fehler: ', /*EXCEPTION_TEXT, '-',*/ EXCEPTION_DETAIL, /*'-', EXCEPTION_HINT,*/ chr(10) );
            UPDATE x_950_import.op2 SET error_message = substr( coalesce( EXCEPTION_DETAIL, EXCEPTION_TEXT, EXCEPTION_HINT ), 1, 150 ) WHERE dbrid IN ( rec.dbrid );
          END;
        END;

    END LOOP;

    RETURN _fehler;
 END $$ LANGUAGE plpgsql VOLATILE;
---